﻿using System;
using System.Collections;

/// <summary>
///     Przedstawia opis pojedynczej strony internetowej
/// </summary>
public class WebSite
{
    const string http = "http://";
    public static readonly string currentDate
        = new DateTime().ToString();

    string siteName;
    string url;
    string description;

    public WebSite()
        : this("Brak strony", "brak.url", "Brak opisu") { }

    public WebSite(string newSite)
        : this(newSite, "brak.url", "Brak opisu") { }

    public WebSite(string newSite, string newURL)
        : this(newSite, newURL, "Brak opisu") { }

    public WebSite(string newSite,
                   string newURL,
                   string newDesc)
    {
        SiteName = newSite;
        URL = newURL;
        Description = newDesc;
    }

    public override string ToString()
    {
        return siteName +
               ", " +
               url +
               ", " +
               description;
    }

    public override bool Equals(object evalString)
    {
        return this.ToString() == evalString.ToString();
    }

    public override int GetHashCode()
    {
        return this.ToString().GetHashCode();
    }

    protected string ValidateUrl(string url)
    {
        if (!(url.StartsWith(http)))
        {
            return http + url;
        }
        return url;
    }

    public string SiteName
    {
        get
        {
            return siteName;
        }
        set
        {
            siteName = value;
        }
    }

    public string URL
    {
        get
        {
            return url;
        }
        set
        {
            url = ValidateUrl(value);
        }
    }

    public string Description
    {
        get
        {
            return description;
        }
        set
        {
            description = value;
        }
    }

    ~WebSite() { }
}
